# 界面配置

配置文件是JSON格式。APP端会优先使用此文件夹下的配置，如果想使用默认格式则可以删除相关配置文件或者修改文件名，让系统找不到。
``` json
{
    "name":"模块名称",
    "fields":{
        "code": {
            "field": "code",
            "title": "编号",
            "fixedWidth": 120,
            "required": true
        },
        "name": {
            "field": "name",
            "title": "名称",
            "fixedWidth": 120
        },
         "qty": {
            "field": "qty",
            "title": "数量",
            "numeric": true,
            "fixedWidth": 90,
            "lt0TextColor": "error",
            "valueStyle": "\"color\": \"primary\""
        },
        "amount": {
            "field": "amount",
            "title": "金额",
            "numeric": true,
            "fixedWidth": 100,
            "lt0TextColor": "error",
            "valueStyle": "\"color\": \"primary\""
        }
    },
    "outfields":[
        "code",
        "name",
        "qty",
        "amount"
    ],
    "sumfields":{
        "qty": "",
        "amount": ""
    }
}
```

配置文件内容包含fields，outfields，sumfields。

fields是字段定义(key，value集合)，key一般为字段名，value中包含了 field(字段名)，title(表格样式标题，卡片样式Label)，fixedWidth（表格样式固定宽度），required（必须输出），numeric（是否是数字），lt0TextColor（值小于0时文本颜色），valueStyle（值的显示样式）,_fillrow(卡片时独占一行，默认每行2个字段数据)。内容都可以根据实际情况做修改，例如有些客户货号长度比较长，可以把fixedWidth修改大些，并加上_fillrow为true独占一行。

outfields是输出字段列表（对应上面fields的key），默认会按此内容顺序输出。

sumfields是合计栏(key，value集合),key为输出字段（对应上面fields的key）,value为空字符串时会对此字段相加合计(sum).